`timescale 1ns / 1ps
module clk_div(input clk_i, input rst_i, output reg clk_o);

//deklaracja sygnaw wewntrznych
parameter DivRatio=1000;
reg [CLogB2(DivRatio-1)-1:0] counter;
//ceil of the log base 2
function integer CLogB2;
	input [31:0] Depth;
	integer i;
	begin
	 	i = Depth;		
		for(CLogB2 = 0; i > 0; CLogB2 = CLogB2 + 1)
			i = i >> 1;
	end
endfunction
always @(posedge clk_i or posedge rst_i)
if (rst_i)
  // obsuga czci asynchronicznej bloku always
  begin
      counter=0;
		clk_o=1'b0;
  end
else
	begin// obsuga czci synchronicznej bloku always
		if (counter==DivRatio-1)
			counter=0;
		else
			counter=counter+1;
		if (counter==0)
			clk_o=1'b0;
		if (counter==DivRatio/2)
			clk_o=1'b1;
	end
  

endmodule
