`timescale 1ns / 1ps
module gray_counter(
    input clk_i,
    input rst_i,
    output reg [3:0] gray_o
    );
always @(posedge clk_i or posedge rst_i)
	if (rst_i)
		gray_o = 4'b0;
	else
		begin
			case (gray_o)
				4'b0000: gray_o = 4'b0001;
				4'b0001: gray_o = 4'b0011;
				4'b0011: gray_o = 4'b0010;
				4'b0010: gray_o = 4'b0110;
				4'b0110: gray_o = 4'b0111;
				4'b0111: gray_o = 4'b0101;
				4'b0101: gray_o = 4'b0100;
				4'b0100: gray_o = 4'b1100;
				4'b1100: gray_o = 4'b1101;
				4'b1101: gray_o = 4'b1111;
				4'b1111: gray_o = 4'b1110;
				4'b1110: gray_o = 4'b1010;
				4'b1010: gray_o = 4'b1011;
				4'b1011: gray_o = 4'b1001;
				4'b1001: gray_o = 4'b1000;
				4'b1000: gray_o = 4'b0000;
				default: gray_o = 4'b0;
			endcase
		end
endmodule
