`timescale 1ns / 1ps
module gray_to_7seg(input [3:0] g_i, output reg [7:0] seg7_o);

function [7:0] g_to_7seg;
	input[3:0] gray_in;
	case (gray_in)
		4'b0000: g_to_7seg = 8'b00000011; //0
		4'b0001: g_to_7seg = 8'b10011111; //1
		4'b0011: g_to_7seg = 8'b00100101; //2
		4'b0010: g_to_7seg = 8'b00001101; //3
		4'b0110: g_to_7seg = 8'b10011001; //4
		4'b0111: g_to_7seg = 8'b01001001; //5
		4'b0101: g_to_7seg = 8'b01000001; //6
		4'b0100: g_to_7seg = 8'b00011111; //7
		4'b1100: g_to_7seg = 8'b00000001; //8
		4'b1101: g_to_7seg = 8'b00001001; //9
		4'b1111: g_to_7seg = 8'b00010001; //10 - A
		4'b1110: g_to_7seg = 8'b11000001; //11 - B
		4'b1010: g_to_7seg = 8'b01100011; //12 - C
		4'b1011: g_to_7seg = 8'b10000101; //13 - D
		4'b1001: g_to_7seg = 8'b01100001; //14 - E
		4'b1000: g_to_7seg = 8'b01110001; //15 - F
		default: //g_to_7seg = 8'b11111101;
					begin 
						g_to_7seg = 8'b11111101;
						$display("Bad input vector");
					end
	endcase
endfunction

always @*
	seg7_o = g_to_7seg(g_i);

endmodule
