`timescale 1ns / 1ps

module tb_all;

	// Inputs
	reg clk_i;
	reg rst_i;

	// Outputs
	wire [3:0] led7_an_o;
	wire [7:0] led7_seg_o;
	wire [3:0] gray_o;

	// Instantiate the Unit Under Test (UUT)
	div_gray_decoder uut (
		.clk_i(clk_i), 
		.rst_i(rst_i), 
		.led7_an_o(led7_an_o), 
		.led7_seg_o(led7_seg_o), 
		.gray_o(gray_o)
	);
	defparam uut.clk_div1.DivRatio = 5;
	initial begin
		// Initialize Inputs
		clk_i = 0;
		rst_i = 1;
		#13
		rst_i = 0;
	end
	initial
		forever #10 clk_i = !clk_i;
      
endmodule

