/**************************************************************

File Name:	fir_blk_test.asm
		
Date Modified:	1/5/99	RFG
				7/11/00 PPG

Purpose:	Program to call fir_blk.asm

**************************************************************/

#include    "def21161.h"

//#define     TAPS    64		/* length of filter */
//#define     N       128		/* number of samples */


#define     TAPS    256		/* length of filter */
#define     N       256


.extern	fir;

/* DM data */
.section/dm seg_dmda;
.ALIGN 2;
.var    dline[TAPS];			/* delay line compensate for circ buffer, see comments in block_fir.asm */
.ALIGN 2;
.var    input[N] = "y1.dat";	/* array of samples */

.ALIGN 2;
.var input2[N] = "y.dat";

/* PM data */
.section/dm seg_pmda;
.ALIGN 2;
.var    coeffs[TAPS] = "wsp256.dat";

.ALIGN 2;
.var    output[N];/* Output array.  The first and last entries are dummy */
									    /* entries to allow an optimization in the fir.*/
.ALIGN 2;
.var e[N];

.Align 2;
.var mju=0.001;
									    

/* PM interrupt vector code */
.section/pm   seg_rth;
Reserved_1:     rti; nop; nop; nop;
Chip_Reset:     idle; jump start; nop; nop;


/* program memory code */
.section/pm seg_pmco;


/* Initialization code */
start:
      b0 = dline;
      l0 = @dline;
	  
	  b1 = input;
	  l1 = @input;
	  
	  b2 = dline;
	  l2 = @dline;
	  
	  b3 = input2;
	  l3 = @input2;
	  
	  b4 = dline;
	  l4 = @dline;

	  b7 = dline;
	  l7 = @dline;
	  
	  b8 = coeffs;
	  l8 = @coeffs;
	  
	  b9 = output;
	  l9 = @output;

	  b10 = coeffs;
	  l10 = @coeffs;
	  
	  b11 = coeffs;
	  l11 = @coeffs;
	  
	  b14 = e;
	  l14 = @e;
	  
	  b15 = mju;
	  
	   bit set MODE1 CBUFEN;
	  //m0=0;
	 // m1=1;
	 // m2=-1;
	 // m3=2;
	  
	  m0=0;
	  m1=1;
	  m2=-1;
	  m3=2;
	  m4=-2;
	  
	  m8=-1;
	  m9=2;
	  m10=1;
	  m11=-2;
	  m12=0;
	  r1=N/2;
	  f6=pm(i15,m12);
	  
	  r2=(N-2)/2;

	  wait1: 	  
	  call fir (db);
	  f9 = 0;
	  s6=f6;

/* Terminate and wait */
  jump wait1;

