/********************************************************************************
*                                                                               *
*   AD1852 SPI slave initialization for the 21161 EZ-KIT Lite                   *
*																				*
*                                                                               *
*********************************************************************************/
	
/* ADSP-21161 System Register bit definitions */
#include 	"def21161.h"
.GLOBAL		Init_AD1852_DACs;

// AD1852 DAC SPI control/volume register definitions
#define		VOLUME_LEFT		0x0
#define		VOLUME_RIGHT	0x2
#define		CONTROL_REG		0x1

// AD1852 control word parameters
#define		DEASSERT_RESET	0x0000
#define		INTERP2xMODE	0x0800
#define		INTERP4xMODE	0x0400
#define		WL_24_BIT_DATA	0x0000
#define		WL_20_BIT_DATA	0x0100
#define		WL_16_BIT_DATA	0x0200
#define		RESET_AD1852	0x0080
#define		SOFT_MUTE		0x0040
#define		RIGHT_JUSTIFIED	0x0000
#define		I2S_JUSTIFIED	0x0010
#define		LEFT_JUSTIFIED	0x0020
#define		DSP_SERIAL		0x0030
#define		NO_DEMPH_FILTER	0x0000
#define		FILTER_44_1_kHz	0x0004
#define		FILTER_32_kHz	0x0008
#define		FILTER_48_kHz	0x000C	

.SECTION/DM	dm_data;
.var spi_tx_buf[5] =	RESET_AD1852 | CONTROL_REG, 	// reset AD1852
						DEASSERT_RESET | CONTROL_REG,	// remove reset command
						WL_24_BIT_DATA | I2S_JUSTIFIED | NO_DEMPH_FILTER | CONTROL_REG, 
                       	0x00FC | VOLUME_LEFT, 
						0x00FC | VOLUME_RIGHT;

.SECTION/pm pm_code;

Init_AD1852_DACs:
		r0=0x00000000;						// initially clear SPI control register
		dm(SPICTL)=r0;

SPIDMA_setup:
		r0=spi_tx_buf; 		dm(IISTX)=r0;
		r0=1;				dm(IMSTX)=r0;
		r0=@spi_tx_buf;		dm(CSTX)=r0;

		bit set LIRPTL SPITMSK;				// enable SPI TX interrupts
		bit set MODE1 IRPTEN;				// allow global interrupts
		bit set IMASK LPISUMI;				// unmask spi interrupts

		/* configure SPI port for interface to the AD1852 */
		ustat1=dm(SPICTL);       						 
		bit set ustat1 SPIEN|SPTINT|TDMAEN|MS|FLS1|CPHASE|DF|WL16|BAUDR4|PSSE|DCPH0|SGN|GM; 
		bit clr ustat1 CP|FLS0|FLS2|FLS3|NSMLS|DMISO|OPD|PACKEN|SENDZ|RDMAEN|SPRINT;
		dm(SPICTL) = ustat1;				//enable SPI port
	
DAC_init_not_done_yet:
//		idle;		
		R1 = DMA9ST;						// Test for SPITX DMA completion
		R0 = DM(DMASTAT);
		R0 = R0 AND R1;
		IF NE jump DAC_init_not_done_yet;

		bit clr LIRPTL SPITMSK;				// enable SPI TX interrupts
		bit clr IMASK LPISUMI;				// unmask spi interrupts

		R0 = 0;		DM(SPICTL) = R0;		// disable SPI Port
		
		RTS;
Init_AD1852_DACs.end:
