/*                                                                                         /
/   ROUTINE TO CLEAR AND RESET ALL SPORT1 REGISTERS                                        /
/                                                                                          /
/                                                                                          /
/   This routine simply clears all SPORT0/1 ctrl and DMA registers back to their           /
/   default states so that we can reconfigure it for our AD1836 application.               /
/                                                                                          /
/                                                                                          / */
/* ///////////////////////////////////////////////////////////////////////////////////////// */

/* ADSP-21161 system Register bit definitions */
#include 	"def21161.h"

.GLOBAL		Clear_All_SPT_Regs;

.section /pm 	pm_code;

Clear_All_SPT_Regs:
	IRPTL = 0x00000000;		/* clear pending interrupts */
	bit clr imask SP0I|SP1I|SP2I|SP3I; 

	R0 = 0x00000000;			
	dm(SPCTL0) = R0;		/* sport0 control register */	
	dm(SPCTL1) = R0;		/* sport1 control register */
	dm(SPCTL2) = R0;		/* sport3 control register */
	dm(SPCTL3) = R0;		/* sport4 control register */
	dm(DIV0) = R0;			/* sport0 frame sync divide register */	
	dm(DIV1) = R0;			/* sport1 frame sync divide register */	
	dm(DIV2) = R0;			/* sport2 frame sync divide register */	
	dm(DIV3) = R0;			/* sport3 frame sync divide register */				

	/* SPORT 0 & 2 Miscellaneous Control Bits Registers */
	R0 = 0x00000000;		/* Enable SPORT loopback bit 12 */
	dm(SP02MCTL) = R0;
	dm(SP13MCTL) = R0;

	/* sport0 receive multichannel word enable registers */
	R0 = 0x00000000;  		/* multichannel mode disabled */
	dm(MR0CS0) = R0;			
	dm(MR0CS1) = R0;
	dm(MR0CS2) = R0;			
	dm(MR0CS3) = R0;
	
	/* sport1 receive multichannel word enable registers */
	R0 = 0x00000000;  		/* multichannel mode disabled */
	dm(MR1CS0) = R0;			
	dm(MR1CS1) = R0;
	dm(MR1CS2) = R0;			
	dm(MR1CS3) = R0;
	
	/* sport2 transmit multichannel word enable registers */
	R0 = 0x00000000;  		/* multichannel mode disabled */
	dm(MT2CS0) = R0;			
	dm(MT2CS1) = R0;
	dm(MT2CS2) = R0;
	dm(MT2CS3) = R0;	

	/* sport3 transmit multichannel word enable registers */
	R0 = 0x00000000;  		/* multichannel mode disabled */
	dm(MT3CS0) = R0;			
	dm(MT3CS1) = R0;
	dm(MT3CS2) = R0;
	dm(MT3CS3) = R0;

	/* sport0 receive multichannel companding enable registers */
	R0 = 0x00000000;		/* no companding */
	dm(MR0CCS0) = R0;				
	dm(MR0CCS1) = R0;
	dm(MR0CCS2) = R0;
	dm(MR0CCS3) = R0;
	
	/* sport1 receive multichannel companding enable registers */
	R0 = 0x00000000;		/* no companding */
	dm(MR1CCS0) = R0;				
	dm(MR1CCS1) = R0;
	dm(MR1CCS2) = R0;
	dm(MR1CCS3) = R0;
	
	/* sport2 transmit multichannel companding enable registers */
	R0 = 0x00000000;		/* no companding */
	dm(MT2CCS0) = R0;				
	dm(MT2CCS1) = R0;
	dm(MT2CCS2) = R0;
	dm(MT2CCS3) = R0;

	/* sport3 transmit multichannel companding enable registers */
	R0 = 0x00000000;		/* no companding */
	dm(MT3CCS0) = R0;				
	dm(MT3CCS1) = R0;
	dm(MT3CCS2) = R0;
	dm(MT3CCS3) = R0;
	
   	RTS;
Clear_All_SPT_Regs.end:





