/* ************************************************************************************	*/
/*                                                                                      */
/*                           ADSP-21161 INTERRUPT VECTOR TABLE                          */
/*                                                                                      */
/*                   For use with the 21161 Unibub and 21161 EZ-Kit-LITE                */
/*                                                                                      */
/*    J.T.                                                                              */
/*    ADI DSP Central Applications Engineering                                          */
/*    10/3/00                                                                           */
/* ************************************************************************************ */


.EXTERN		_main;
.EXTERN		Init_DSP;
.EXTERN 	Count_SPORT1_RX_IRQs;
.EXTERN 	Count_SPORT3_TX_IRQs;
.EXTERN		Process_AD1836_Audio_Samples;

.section /dm dm_data;
/* SPORT TX ISR counter, for debug purposes */
.VAR		SPORT2_TXDMA_counter = 0;



.section/PM   isr_tbl;		/* 21161 Interrupt Service Table */
 
/* 0x00 Reserved Interrupt */
/*		0x00	0x01	0x02	0x03 */
/*		NOP;	NOP;	NOP;	NOP; */		// Reserved interrupt

// Vector for RESET:
/* 0x04 - reset vector starts at location 0x40005 */
RSTI_scv: 		/* IDLE;	*/				// Implicit IDLE instruction for boot kernel cleanup
				call Init_DSP;
			  	NOP;
	  			jump _main;

/* 0x08 -  Vector address for illegal input condition detected */
IICD_svc: 		RTI;
				RTI;
				RTI;
				RTI;

/* 0x0C - Vector address for status stack/loop stack overflow or PC stack full: */
SOVFI_svc:   	RTI;
				RTI;
				RTI;
				RTI;

// 0x10 - Vector address for high priority timer interrupt:
TMZHI_svc:   	RTI;
				RTI;
				RTI;
				RTI;

// 0x14 - Vector address for Vector Interrupt:
VIRPTI_svc:  	RTI;
				RTI;
				RTI;
				RTI;

// 0x18 - Vector address for Hardware Interrupt 2 (IRQ2):
IRQ2I_svc:   	RTI;
				RTI;
				RTI;
				RTI;

// 0x1C - Vector address for Hardware Interrupt 1 (IRQ1):
IRQ1I_svc:   	RTI;
				RTI;
				RTI;
				RTI;
	

// 0x20 - Vector address for Hardware Interrupt 0 (IRQ0):
IRQ0I_svc:   	RTI;
				RTI;
				RTI;
				RTI;

/* 0x24  - Reserved interrupt */
reserved_0x24:	NOP;NOP;NOP;NOP;		// Reserved interrupt


// Vectors for Serial port DMA channels:
/* 0x28 - Vector address for serial port 0 primary A, secondary B RX/TX buffers (DMA Channels 0 & 1) */
SP0I_svc:   	JUMP Process_AD1836_Audio_Samples;
				RTI;
				RTI;
				RTI;

/* 0x2C - Vector address for serial port 1 primary A, secondary B RX/TX buffers (DMA Channel 2 & 3) */
SP1I_svc:   	JUMP Count_SPORT1_RX_IRQs;
				RTI;
				RTI;
				RTI;

/* 0x30 - Vector address for serial port 2 primary A, secondary B RX/TX buffers (DMA Channel 4 & 5) */
SP2I_svc:   	r0=dm(SPORT2_TXDMA_counter);			/* get last count */
				RTI(db);
				r0=r0+1;								/* increment count */
				dm(SPORT2_TXDMA_counter)=r0;			/* save updated count */
				
/* 0x34 - Vector address for serial port 3 primary A, secondary B RX/TX buffers (DMA Channel 6 & 7) */
SP3I_svc:   	JUMP Count_SPORT3_TX_IRQs;
				RTI;
				RTI;
				RTI;

// Vectors for link port DMA channels:
/* 0x38 - Vector address for Link Buffer 0 (DMA Channel 8) */
LP0I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x3C - Vector address for Link Buffer 1 (DMA Channel 9) */
LP1I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x40 - Vector address for SPI Receive (DMA Channel 8) */
SPIRI_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x44 - Vector address for SPI Receive (DMA Channel 9) */
SPITI_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x48 - Reserved Interrupt */
reserved_0x48:	RTI;	RTI;	RTI;	RTI;

/* 0x4C - Reserved Interrupt */
reserved_0x4C:	RTI;	RTI;	RTI;	RTI;

// Vectors for External port DMA channels:
/* 0x50 - Vector address for External Port Buffer 0 (DMA Channel 10) */
EP0I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x54 - Vector address for External Port Buffer 0 (DMA Channel 11) */
EP1I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x58 - Vector address for External Port Buffer 0 (DMA Channel 12) */
EP2I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

/* 0x5C - Vector address for External Port Buffer 0 (DMA Channel 13) */
EP3I_svc:  		RTI;
				RTI;
				RTI;
				RTI;

// 0x60 - Vector address for Link service request:
LSRQI_svc:    	RTI;
				RTI;
				RTI;
				RTI;

// 0x64 - Vector address for DAG1 buffer 7 circular buffer overflow:
CB7I_svc:    	RTI;
				RTI;
				RTI;
				RTI;

// 0x68 - Vector address for DAG2 buffer 15 circular buffer overflow:
CB15I_svc:   	RTI;
				RTI;
				RTI;
				RTI;

// 0x6C - Vector address for lower priority timer interrupt:
TMZLI_svc:   	RTI;
				RTI;
				RTI;
				RTI;

// 0x70 - Vector address for fixed-point overflow interrupt:
FIXI_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x74 - Vector address for floating-point overflow exception interrupt:
FLTOI_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x78 - Vector address for floating-point underflow exception interrupt:
FLTUI_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x7C - Vector address for floating-point invalid exception interrupt:
FLTII_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x80 - Vector address for user software interrupt 0:
SFT0I_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x84 - Vector address for user software interrupt 1:
SFT1I_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x88 - Vector address for user software interrupt 2:
SFT2I_svc:		RTI;
				RTI;
				RTI;
				RTI;

// 0x8C - Vector address for user software interrupt 3:
SFT3I_svc:		RTI;
				RTI;
				RTI;
				RTI;

/* 0x90 - Reserved Interrupt */
reserved_0x90:	RTI;	RTI;	RTI;	RTI;

	





