/***   INIT_21161_EZKIT.ASM   ***************************************************
*                                                                               *
*       ADSP-21161 EZ-KIT Initialization and Main Program Shell                 *
*       Developed using the ADSP-21161 EZ-KIT LIte Evaluation Platform          *
*                                                                               *
*                                                                               *
*                                                                               *
*********************************************************************************/
	
/* ADSP-21161 System Register bit definitions */
#include 	"def21161.h"

.GLOBAL		_main;
.GLOBAL		Init_DSP;
.EXTERN		init_21161_SDRAM_controller;
.EXTERN		Program_SPORT02_TDM_Registers;
.EXTERN		Program_AD1836_regs_via_SPI;
.EXTERN		Program_SPORT02_DMA_Channels;
.EXTERN		AD1836_Codec_Initialization;
.EXTERN		Init_AD1852_DACs;
.EXTERN		Reg_SPI_Code_init;
.EXTERN		Clear_All_SPT_Regs;
.EXTERN		user_code_init;

/*---------------------------------------------------------------------------*/

.section /pm pm_code;

_main:
	 
	CALL Clear_All_SPT_Regs;				/* Clear and Reset SPORTs and DMAs */
	call init_21161_SDRAM_controller;		/* Initialize External Memory */
	call Program_AD1836_regs_via_SPI;		/* Use SPORTs 1&3 to talk to AD1836 SPI interface */
											/* and program AD1836 Registers*/	
	call Init_AD1852_DACs;
	call Program_SPORT02_TDM_Registers;		/* Initialize SPORTs for codec communications */
	call Program_SPORT02_DMA_Channels;		/* Start Serial Port 1 tx and rx DMA Transfers */

	call user_code_init;					/* initialize user buffers */

	IRPTL = 0x00000000;						/* clear pending interrupts */
	bit set imask SP0I|SP2I;				/* start audio processing, enable SPORT1 tx & rx int */
	bit set imask IRQ0I | IRQ1I | IRQ2I;	/* irq0, irq1 and irq2 enabled */

	ustat2 = dm(SP02MCTL);
	bit set ustat2 MCE;
	dm(SP02MCTL) = ustat2;	

	call Blink_LEDs_Test;					/* Are We Alive? */

wait_forever:								/* wait forever loop */
	idle;
 	jump wait_forever;

_main.end:

/*--------------------------------------------------------------------------------------*/
/* Note: This routine is first called at the Reset Vector in the Interrupt Vector Table */
/*--------------------------------------------------------------------------------------*/

Init_DSP:
	/* *** Enable circular buffering in MODE1 Register for revision 0.x silicon.
           Important when porting 2106x code!!! */
	bit set MODE1 CBUFEN;

	/* Setup hardware interrupts, FLAG LEDs and pushbutton */
	ustat2=0x00000000;

	/* flags 4-9 are outputs for LEDs, turn on all LEDs*/
	bit set ustat2 FLG9O|FLG8O|FLG7O|FLG6O|FLG5O|FLG4O;
	bit set ustat2 FLG9|FLG8|FLG7|FLG6|FLG5|FLG4;
	dm(IOFLAG)=ustat2;

	bit clr MODE2 FLG0O | FLG1O | FLG2O | FLG3O;  /* flag 0-3 are inputs from pushbutton switches  */

	IMASK = 0x0; 
	LIRPTL = 0x0;
	IRPTL = 0x00000000;						/* clear pending interrupts */
	bit set mode2 IRQ2E | IRQ0E | IRQ1E;	/* irqx edge sensitive 	*/
	bit set mode1 IRPTEN | NESTM;   		/* enable global interrupts, nesting */	
	bit set imask IRQ0I | IRQ1I | IRQ2I;	/* irq0, irq1 and irq2 enabled */

	L0 = 0;
	L1 = 0;
	L2 = 0;
	L3 = 0;
	L4 = 0;
	L5 = 0;
	L6 = 0;
	L7 = 0;
	L8 = 0;
	L9 = 0;
	L10 = 0;
	L11 = 0;
	L12 = 0;
	L13 = 0;
	L14 = 0;
	L15 = 0;

	rts;

Init_DSP.end:

Blink_LEDs_Test:
		/* Setup FLAG 4-11 outputs */	
		ustat2=dm(IOFLAG);
		bit set ustat2 FLG9O|FLG8O|FLG7O|FLG6O|FLG5O|FLG4O;
		bit clr ustat2 FLG9|FLG8|FLG7|FLG6|FLG5|FLG4;		/* clear flags to start*/
		dm(IOFLAG)=ustat2;

		/* Blink flags 5 times (twice per second) */
		lcntr=10, do blink_loop until lce;
			lcntr=6250000;
			do delay until lce;
delay:			nop;
			bit tgl ustat2 FLG9|FLG8|FLG7|FLG6|FLG5|FLG4;
blink_loop:	dm(IOFLAG)=ustat2;

		rts;
















