/* ///////////////////////////////////////////////////////////////////////////////////
/    talkthru.asm                                                                    /
/                                                                                    /
/    Receives input from the AD1836 internal ADCs via the ADSP-21161 serial port     /
/    (SPORT0), and transmits the data back to the AD1836 internal DACs (SPORT2).     /
/                                                                                    /
/    The samples from the AD1836 are 24 bit and are left-justified in the upper      /
/    24-bits of the the 32-bit word (timeslot).  No shifting of the data is required /
/    in order to preserve the sign of the samples when they are converted to         /
/    floating point numbers, as the audio data is already in the assumed 1.31 format./
/    The values are also scaled to the range +/-1.0  with the integer to float       /
/    conversion (f0 = float r0 by r1).                                               /
/////////////////////////////////////////////////////////////////////////////////// 

OPIS ALGORYTMOW ADAPTACYJNYCH (LMS, RLS, ...)     
INPUT:      
	f0= u(n)= wejscie referencyjne (wejscie filtru adaptacyjnego (FIR) 	(xREG_REF)
    f1 lub f9 = d(n)= wejscie PRIMARY 									(xREG_PRIMARY)  
		//f1 for lms, nlms, llms, selms, sdlms, sslms,sylms
		//f9 for latlms and RLS
OUPUT:
	f13= y(n)= filter output											(xREG_OUTPUT)
	f1 lub f6 = e(n)= filter "a priori" error signal					(xREG_ERROR)		
		//f6 for lms, llms, nlms, sdlms, sylms, latlms
		//f1 for selms, sslms, rls     
																					
OPIS WEJSC/WYJSC:
Left_Channel_In0 	-> podac sygnal primary (np. mowa+przefiltrowany szum)
Right_Channel_In0	-> podac sygnal referencyjny (np. szum)
Left_Channel_Out0	-> sygnal bledu (czyli odszumiony sygnal mowy)
Left_Channel_Out1	-> sygnal primary		//output=input w celu sprawdzenia poprawnosci
Right_Channel_Out1	-> sygnal referencyjny	//-------------||---------------------------

*/

/* ADSP-21161 System Register bit definitions */
#include "def21161.h"

#define LMS
//#define RLS

#ifdef RLS
	#define INIT 		rls_init
	#define ALG 		rls_alg
	#define fREG_PRIMARY	f9
	#define rREG_PRIMARY	r9
	#define fREG_ERROR 		f1	
	#define rREG_ERROR 		r1
#endif
#ifdef LMS
	#define INIT		lms_init
	#define ALG			lms_alg	
	#define fREG_PRIMARY	f1
	#define rREG_PRIMARY	r1	
	#define fREG_ERROR		f6	
	#define rREG_ERROR		r6	
#endif	

//definicje wspolne dla wszystkich algorytmow
#define fREG_REF		f0
#define rREG_REF		r0
#define fREG_OUTPUT		f13
#define rREG_OUTPUT		r13

.EXTERN INIT, ALG; 


/*----------------------------------------------------------------------------------*/

.section /pm	  pm_data;		//define your user program memory variables here
	


.section /dm      dm_data;		//define your user data memory variables here




.section /pm pm_code;

.EXTERN		RX_left_flag;

.EXTERN		Left_Channel_In0;
.EXTERN		Right_Channel_In0;
.EXTERN		Left_Channel_In1;
.EXTERN		Right_Channel_In1;

.EXTERN		Left_Channel_Out0;
.EXTERN		Right_Channel_Out0;

.EXTERN		Left_Channel_Out1;
.EXTERN		Right_Channel_Out1;
.EXTERN		Left_Channel_Out2;
.EXTERN		Right_Channel_Out2;

.EXTERN 	Left_Channel_AD1852;
.EXTERN 	Right_Channel_AD1852;


.GLOBAL		process_audio;
.GLOBAL		user_code_init;

	 
user_code_init:
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	/* insert your initialization code for circular (delay) buffers */ 
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	call INIT;
	rts;
user_code_init.end:


/* //////////////////////////////////////////////////////////////////////////////// *
 *                           audio processing routine                               *
 * //////////////////////////////////////////////////////////////////////////////// */

process_audio:
	/* loop back 'non-processed' ADC0/ADC1 data to DAC0, DAC2, and external AD1852 DAC */
	r0 = dm(Left_Channel_In0); 	dm(Left_Channel_Out1) = r0;
	r0 = dm(Right_Channel_In0); dm(Right_Channel_Out1) = r0;
	r0 = dm(Left_Channel_In1); 	dm(Left_Channel_Out2) = r0;  dm(Left_Channel_AD1852) = r0;	
	r0 = dm(Right_Channel_In1);	dm(Right_Channel_Out2) = r0; dm(Right_Channel_AD1852) = r0;	

	/* now let's process ADC1 L/R channel data and send results to DAC1 L/R channels */
	r2 = -31;        				/* scale the input samples to the range of +/-1.0 */                           
	rREG_PRIMARY	= DM(Left_Channel_In0);  	/* get right AD1836 ADC0 input sample */
	rREG_REF 		= DM(Right_Channel_In0);		/* get left AD1836 ADC0 input sample */		
		
	DM(Left_Channel_Out1) = rREG_PRIMARY; 	/* send left channel result to AD1836 Left DAC0 */
	DM(Right_Channel_Out1) = rREG_REF;	/* send right channel result to AD1836 Right DAC0 */
   	//DM(Right_Channel_Out0) = rREG_PRIMARY;
	
   	//PRZYGOTOWANIE DANYCH WEJSCIOWYCH
	fREG_PRIMARY = float rREG_PRIMARY by r2;
	fREG_REF = float rREG_REF by r2; 			/* convert to floating point */

	//WYWOLANIE ALGORYTMU FILTRACJI ADAPTACYJNEJ
	call ALG;
	
	
	r2 = 31;						/* scale the result back up to MSBs */
	rREG_OUTPUT = fix fREG_OUTPUT by r2;				/* convert back to fixed point */
	rREG_ERROR = fix fREG_ERROR by r2;
		
	rts (db);
	DM(Left_Channel_Out0) = rREG_ERROR; 	/* send left channel result to AD1836 Left DAC0 */
	//DM(Right_Channel_Out0) = rREG_OUTPUT;	/* send right channel result to AD1836 Right DAC0 */

process_audio.end:


