/******************************************************************************
*   Setup for the SDRAM Controller for 21161 EZ-KIT Lite                      *
*                                                                             *
*   Assumes SDRAM part# Micron MT48LC16M16A1-7SE                              *
*       SDCLK=100MHz                                                          *
*       tCK=8ns min @ CL=2  -> SDCL=1 [CAS Latency]                           *
*       tRAS=50ns min       -> SDTRAS=3 [active command delay]                *
*       tRP=20ns min        -> SDTRP=2  [precharge delay]                     *
*       tRCD=20 ns min      -> SDTRCD=2 [CAS-to-RAS delay]                    *
*       tREF=64ms/4K rows   -> SDRDIV=(2(30MHz)-CL-tRP-4)64ms/4096=937cycles  *
*                                                                             *
*   3 SDRAMs by 16 bits wide total = 16Mbit x 48                              *
*   Mapped to MS0 addresses 0x00200000-0x002fffff                             *
*                                                                             *
*******************************************************************************/

#include "def21161.h"
#define sdram_size 0xfffff

.section/DM/NO_INIT segsdram;
//.VAR	sdram[sdram_size];


.section/PM pm_code;
.GLOBAL	init_21161_SDRAM_controller;
//.GLOBAL SDRAM_memory_pass_test;

//.EXTERN SDRAM_memory_pass_test;


init_21161_SDRAM_controller:
		ustat1=dm(WAIT);
		bit clr ustat1 0x000FFFFF;	/*clear MSx waitstate and mode*/
		dm(WAIT)=ustat1;

		ustat1=0x1000;				/*refresh rate*/
		dm(SDRDIV)=ustat1;

		ustat1=dm(SDCTL);			/*mask in SDRAM settings*/
		// SDCTL = 0x02014231;
		// 1/2 CCLK, no SDRAM buffering option, 2 SDRAM banks
		// SDRAM mapped to bank 0 only, no self-refresh, page size 256 words
		// SDRAM powerup mode is prechrg, 8 CRB refs, and then mode reg set cmd
		// tRCD = 2 cycles, tRP=2 cycles, tRAS=3 cycles, SDCL=1 cycle                     
		// SDCLK0, SDCLK1, RAS, CAS and SDCLKE activated                          
		bit set ustat1 SDTRCD2|SDCKR_DIV2|SDBN2|SDEM0|SDPSS|SDPGS256|SDTRP2|SDTRAS3|SDCL1;
		bit clr ustat1 SDBUF|SDEM3|SDEM2|SDEM1|SDSRF|SDPM|DSDCK1|DSDCTL;
		dm(SDCTL)=ustat1;

		rts;
init_21161_SDRAM_controller.end:
		


