/***   SPORT_initialization.ASM   ***********************************************
*                                                                               *
*       AD1836/ADSP-21161 SPORT Initialization Driver                           *
*                                                                               *
*		Modified version of Brian Wachob's AD1836 init (DAU Group)              *
*																				*
*                                                                               *
*********************************************************************************/
	
/* ADSP-21161 System Register bit definitions */
#include 	"def21161.h"
#define		NCH_8		0x000000E0	/* Number of MCM channels - 1 	*/

.GLOBAL		Program_SPORT02_TDM_Registers;
.GLOBAL		Program_SPORT02_DMA_Channels;
//.GLOBAL		AD1836_Codec_Initialization;
.GLOBAL		tx2a_buf, rx0a_buf;
//.GLOBAL		Wait_Approx_999us;
//.EXTERN		Wait_Approx_999us, Wait_Approx_167ms, Wait_Approx_1500ms;

//.EXTERN		AD1836_Codec_Initialization;


#define 	Initialize_TDM			0xD380			/* 1101 0001 1000 0000*/

/* AD1836 TDM Timeslot Definitions */
#define		Internal_ADC_L0			0
#define		Internal_ADC_L1			1
#define		AUX_ADC_L0				2
#define		AUX_ADC_L1				3
#define		Internal_ADC_R0			4
#define		Internal_ADC_R1			5
#define		AUX_ADC_R0				6
#define		AUX_ADC_R1				7

#define		Internal_DAC_L0			0
#define		Internal_DAC_L1			1
#define		Internal_DAC_L2			2
#define		AUX_DAC_L0				3
#define		Internal_DAC_R0			4
#define		Internal_DAC_R1			5
#define		Internal_DAC_R2			6
#define		AUX_DAC_R0				7

/* Leave a safety margin of 5x for the 1836 */
#define 	AD1836_RESET_CYCLES		300			
#define 	AD1836_WARMUP_CYCLES	60000		


/*---------------------------------------------------------------------------*/
.section /dm    dm_codec;

.var rx0a_buf[8];					/* receive buffer (DMA)*/
.var tx2a_buf[8] =  0x00000000,		/* transmit buffer (DMA)*/
				  	0x00000000,
				  	0x00000000,
				  	0x00000000,
				  	0x00000000,
				  	0x00000000,
				  	0x00000000,
				  	0x00000000;
	
/* TCB = "Transfer Control Block" */
/* TCB format:    ECx (length of destination buffer),
				  EMx (destination buffer step size),
				  EIx (destination buffer index (initialized to start address)),
				  GPx ("general purpose"),
				  CPx ("Chain Point register"; points to last address (IIx) of
			   								   next TCB to jump to
				                               upon completion of this TCB.),
				  Cx  (length of source buffer),
				  IMx (source buffer step size),
				  IIx (source buffer index (initialized to start address))       */

.var 	rcv0a_tcb[8]  = 0, 0, 0, 0, 0, 8, 1, rx0a_buf;	/* SPORT0 receive tcb */
.var 	xmit2a_tcb[8] = 0, 0, 0, 0, 0, 8, 1, tx2a_buf;  /* SPORT2 transmit tcb */


							   /* grc detects buffer space avail*/

.section /pm 	pm_code;
	
/* ---------------------------------------------------------------------------------------------*/
/* Sport0&2 Control Register Programming 							  	                        */
/* Multichannel Mode dma w/ chain, erly fs, act hi fs, fall edge, no pack, data=16/big/zero 	*/
/* ---------------------------------------------------------------------------------------------*/

Program_SPORT02_TDM_Registers:
	/* sport 0 & 2 frame sync divide registers */
	/* External Clock and Frame Sync generated by AD1836 */
	R0 = 0x00000000;
	dm(DIV0) = R0;
	dm(DIV2) = R0;

	/* SPORT0 and SPORT2 are being operated in "multichannel" mode.
	This is synonymous with TDM mode which is the operating mode for the AD1836 */					

	/* SPORT 0&2  Miscellaneous Control Bits Registers */
	R0 = NCH_8 | MFD1;			/* SP02MCTL = 0x000000E2,  Hold off on MCM enable, and number of TDM slots to 8 active channels */
	dm(SP02MCTL) = R0;			/* Multichannel Frame Delay=1, Number of Channels = 8, LB disabled */

	/* sport0 control register set up as a receiver in MCM */
	R0 = SCHEN_A | SDEN_A | SLEN32; 
	dm(SPCTL0) = R0;			/* sport 0 control register SPCTL0 = 0x000C01F0 */

	/* sport2 control register set up as a transmitter in MCM */
	R0 = SCHEN_A | SDEN_A | SLEN32; 
	dm(SPCTL2) = R0;			/* sport 2 control register, SPCTL2 = 0x000C01F0 */
							
	/* sport0 & sport2 receive and transmit multichannel word enable registers */
	R0 = 0x000000FF;  			
	dm(MR0CS0) = R0;			/* enable receive channels 0-7 */
	dm(MT2CS0) = R0;			/* enable transmit channels 0-7 */

	/* sport0 & sport2 receive & transmit multichannel companding enable registers */
	R0 = 0x00000000;			/* no companding for our 8 active timeslots*/
	dm(MR0CCS0) = R0;			/* no companding on SPORT0 receive */
	dm(MT2CCS0) = R0;			/* no companding on SPORT2 transmit */

	RTS;
Program_SPORT02_TDM_Registers.end:

/*----------------------------------------------------------------------------------*/
/* 		    DMA Controller Programming For SPORT0 and SPORT2 primary A channels     */
/*----------------------------------------------------------------------------------*/

Program_SPORT02_DMA_Channels:
	r1 = 0x0003FFFF;				/* cpx register mask */	

	/* sport2 dma control tx setup and go  */
	r0 = xmit2a_tcb + 7;			/* get DMA chaining internal mem pointer containing tx_buf address */
	r0 = r1 AND r0;					/* mask the pointer */
									/*(Address will be contained in lower 18 bits (bits 17-0);
	  								   Upper 13 bits will be zeroed (bits 19-31);
	  								   Bit 19 is PCI bit ("Program-Controlled Interrupts") */
	r0 = BSET r0 BY 18;				/* set the pci bit */
	dm(xmit2a_tcb + 4) = r0;        /* write DMA transmit block chain pointer to TCB buffer */
	dm(CP2A) = r0;                 	/* transmit block chain pointer, initiate tx0 DMA transfers */

	/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	/* - Note: Tshift2 & TX2A will be automatically loaded with the first 2 values in the  - */
	/* - Tx buffer. The Tx buffer pointer ( II3 ) will increment by 2x the modify value    - */
	/* - ( IM3 ).                                                			       	       - */
	/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	
	/* sport0 dma control rx setup and go */
	r0 = rcv0a_tcb + 7;
	r0 = r1 AND r0;					/* mask the pointer */
	r0 = BSET r0 BY 18;				/* set the pci bit */
	dm(rcv0a_tcb + 4) = r0;      	/* write DMA receive block chain pointer to TCB buffer*/
	dm(CP0A) = r0;                 	/* receive block chain pointer, initiate rx0 DMA transfers */

	RTS;
Program_SPORT02_DMA_Channels.end:
 




