/****************************************************************************************************
/                                                                                                   /
/                            AD1836 - SPORT0 RX INTERRUPT SERVICE ROUTINE                           /
/                                                                                                   /
/    Receives input data from the 2 AD1836 ADCs via SPORT1 and transmits processed audio data 		/
/    back out to the 3 AD1836 Stereo DACs/Line Outputs                                              /
/                                                                                                   /
*****************************************************************************************************
/                                                                                                   /
/   This Serial Port 0 Recieve Interrupt Service Routine performs arithmetic computations on        /
/   the SPORT1 receive DMA buffer (rx_buf) and places results to SPORT1 transmit DMA buffer (tx_buf)/
/                                                                                                   /
/  rx0a_buf[8] - DSP SPORT recieve buffer                                                           /
/  Slot # Description                             DSP Data Memory Address                           /
/  ------ --------------------------------------  -----------------------------------------------   /
/  0      Internal ADC 0 Left Channel             DM(rx0a_buf + 0) = DM(rx0a_buf + Internal_ADC_L0) /
/  1      Internal ADC 1 Left Channel             DM(rx0a_buf + 1) = DM(rx0a_buf + Internal_ADC_L1) /
/  2      External Auxilliary ADC 0 Left Chan.    DM(rx0a_buf + 2) = DM(rx0a_buf + AUX_ADC_L0)      /
/  3      External Auxilliary ADC 1 Left Chan.    DM(rx0a_buf + 3) = DM(rx0a_buf + AUX_ADC_L1)      /
/  4      Internal ADC 1 Right Channel            DM(rx0a_buf + 4) = DM(rx0a_buf + Internal_ADC_R0) /
/  5      Internal ADC 1 Right Channel            DM(rx0a_buf + 5) = DM(rx0a_buf + Internal_ADC_R1) /
/  6      External Auxilliary ADC 0 Right Chan.   DM(rx0a_buf + 6) = DM(rx0a_buf + AUX_DAC_R0)      /
/  7      External Auxilliary ADC 1 Right Chan.   DM(rx0a_buf + 7) = DM(rx0a_buf + AUX_DAC_R1)      /
/                                                                                                   /
/  tx2a_buf[8] - DSP SPORT transmit buffer                                                          /
/  Slot # Description                             DSP Data Memory Address                           /
/  ------ --------------------------------------  -----------------------------------------------   /
/  0      Internal DAC 0 Left Channel             DM(tx0a_buf + 0) = DM(tx0a_buf + Internal_DAC_L0) /
/  1      Internal DAC 1 Left Channel             DM(tx0a_buf + 1) = DM(tx0a_buf + Internal_DAC_L1) /
/  2      Internal DAC 2 Left Channel             DM(tx0a_buf + 2) = DM(tx0a_buf + Internal_DAC_L2) /
/  3      External Auxilliary DAC 0 Left Chan.    DM(rx0a_buf + 3) = DM(tx0a_buf + AUX_DAC_L0)      /
/  4      Internal DAC 0 Right Channel            DM(tx0a_buf + 4) = DM(tx0a_buf + Internal_DAC_R0) /
/  5      Internal DAC 1 Right Channel            DM(tx0a_buf + 5) = DM(tx0a_buf + Internal_DAC_R1) /
/  6      Internal DAC 2 Left Channel             DM(tx0a_buf + 6) = DM(tx0a_buf + Internal_DAC_R3) /
/  7      External Auxilliary DAC 0 Right Chan.   DM(tx0a_buf + 7) = DM(tx0a_buf + AUX_DAC_R0)      /
/                                                                                                   / 
****************************************************************************************************/

/* ADSP-21161 System Register bit definitions */
#include 	"def21161.h"
 
/* AD1836 TDM Timeslot Definitions */
/* 8 successive 32 bit samples (representing 8 channels of audio data) make up the 256 bit TDM frame */

#define		Internal_ADC_L0			0
#define		Internal_ADC_L1			1
#define		AUX_ADC_L0				2
#define		AUX_ADC_L1				3
#define		Internal_ADC_R0			4
#define		Internal_ADC_R1			5
#define		AUX_ADC_R0				6
#define		AUX_ADC_R1				7

#define		Internal_DAC_L0			0
#define		Internal_DAC_L1			1
#define		Internal_DAC_L2			2
#define		AUX_DAC_L0				3
#define		Internal_DAC_R0			4
#define		Internal_DAC_R1			5
#define		Internal_DAC_R2			6
#define		AUX_DAC_R0				7
	
.GLOBAL		Process_AD1836_Audio_Samples;	/* Label of code listed here to get samples into and out of*/
											/* SPORT DMA buffers and process_audio routine*/

.GLOBAL 	Left_Channel_In0;			/* These will tranfer ADC samples of interest from the*/
.GLOBAL 	Right_Channel_In0;			/* Process_AD1836_Audio_Samples routine to the process_audio routine*/
.GLOBAL		Left_Channel_In1;
.GLOBAL		Right_Channel_In1;
.GLOBAL		Left_Channel_SPDIF_rx;
.GLOBAL		Right_Channel_SPDIF_rx;

.GLOBAL 	Left_Channel_Out0;			/* These will bring samples for the DACs back into the*/
.GLOBAL 	Right_Channel_Out0;			/* Process_AD1836_Audio_Samples routine from the process_audio routine*/
.GLOBAL		Left_Channel_Out1;
.GLOBAL		Right_Channel_Out1;
.GLOBAL		Left_Channel_Out2;
.GLOBAL		Right_Channel_Out2;
.GLOBAL		Left_Channel_AD1852;
.GLOBAL		Right_Channel_AD1852;

//.GLOBAL		Left_Channel_Out_Thru;		/* These serve the same function for a different set of audio */
//.GLOBAL 	Right_Channel_Out_Thru;		/* samples destined for the DACs*/

.EXTERN		tx2a_buf;				/* These are the DMA buffers that hold the 8 channels of audio */
.EXTERN		rx0a_buf;				/* immediately pre-transmission and post-reception */

.EXTERN		process_audio;			/* Label of audio algorithm code listed in another file which executes */
									/* a procesing alogorithm on the audio data before it is output */

										/* to the DACs */

//.EXTERN		Left_Channel_Out_Thru;		/* These serve the same function for a different set of audio */
//.EXTERN 	Right_Channel_Out_Thru;		/* samples destined for the DACs*/
										
										
.section /dm    dm_codec;
/* AD1836 stereo-channel data holders - used for DSP processing of audio data received from codec */
.VAR 		Left_Channel_In0;			/* Input values from AD1836 ADCs */
.VAR		Left_Channel_In1;
.VAR 		Right_Channel_In0;
.VAR 		Right_Channel_In1;
.VAR		Left_Channel_SPDIF_rx;
.VAR		Right_Channel_SPDIF_rx;

.VAR		Left_Channel_Out0;			/* Output values for AD1836 DACs */
.VAR 		Left_Channel_Out1;
.VAR 		Left_Channel_Out2;
.VAR		Right_Channel_Out0;
.VAR		Right_Channel_Out1;
.VAR		Right_Channel_Out2;
.VAR		Left_Channel_AD1852;
.VAR		Right_Channel_AD1852;

.VAR 		Left_Channel;				/* can use for intermediate results to next filter stage */		
.VAR 		Right_Channel;				/* can use for intermediate results to next filter stage */	

/* TDM audio frame/ISR counter, for debug purposes */
.VAR		audio_frame_timer = 0;



.section /pm pm_code;

Process_AD1836_Audio_Samples:
	/* get AD1836 left channel input samples, save to data holders for processing */
	r0 = dm(rx0a_buf + Internal_ADC_L0);	dm(Left_Channel_In0) = r0;			
	r0 = dm(rx0a_buf + Internal_ADC_L1);	dm(Left_Channel_In1) = r0;			
	r0 = dm(rx0a_buf + AUX_ADC_L0);			dm(Left_Channel_SPDIF_rx) = r0;

	/* get AD1836 right channel input samples, save to data holders for processing */
	r0 = dm(rx0a_buf + Internal_ADC_R0);	dm(Right_Channel_In0) = r0;			
 	r0 = dm(rx0a_buf + Internal_ADC_R1);	dm(Right_Channel_In1) = r0;		
	r0 = dm(rx0a_buf + AUX_ADC_R0);			dm(Right_Channel_SPDIF_rx) = r0;
   	 					
do_audio_processing:
	call (pc, process_audio);
		 				
	/* ---- DSP processing is finished, now playback results to AD1836 ---- */
playback_AD1836_left_DACs:			/* output processed left ch audio samples to AD1836 */
	r0 = dm(Left_Channel_Out0);		dm(tx2a_buf + Internal_DAC_L0) = r0;
	r1 = dm(Left_Channel_Out1);		dm(tx2a_buf + Internal_DAC_L1) = r1;
	r2 = dm(Left_Channel_Out2);		dm(tx2a_buf + Internal_DAC_L2) = r2;
	r3 = dm(Left_Channel_AD1852);	dm(tx2a_buf + AUX_DAC_L0) = r3;

playback_AD1836_right_DACs:			/* output processed right ch audio samples to AD1836 */
	r0 = dm(Right_Channel_Out0); 	dm(tx2a_buf + Internal_DAC_R0) = r0;
	r1 = dm(Right_Channel_Out1);	dm(tx2a_buf + Internal_DAC_R1) = r1;
	r2 = dm(Right_Channel_Out2);	dm(tx2a_buf + Internal_DAC_R2) = r2;
	r3 = dm(Right_Channel_AD1852);	dm(tx2a_buf + AUX_DAC_R0) = r3;

tx_done:
	r0=dm(audio_frame_timer);			/* get last count */
	rti(db);							/* return from interrupt, delayed branch */
	r0=r0+1;							/* increment count */
	dm(audio_frame_timer)=r0;			/* save updated count */

Process_AD1836_Audio_Samples.end:

/* ////////////////////////////////////////////////////////////////////////////////// */ 

