#ifdef __ECC__ 
/* Insert C Definitions here.... */
int		Setup_AD1836();
void 	Program_SPORT02_TDM_Registers();
void 	Program_SPORT02_DMA_Channels();
void	Receive_Samples();
void	Transmit_Samples();
void	Init_AD1852_DACs();
void 	Setup_SDRAM();
void	Setup_ADSP21161N();
void	Blink_LED_Test( int interations );

extern	float 			Left_Channel0;			/* Input values from AD1836 ADCs */
extern	float			Left_Channel1;
extern	float			Left_Channel2;
extern	float			Left_Channel3;			/* AD1852 */
extern	float 			Right_Channel0;
extern	float 			Right_Channel1;
extern	float 			Right_Channel2;
extern	float 			Right_Channel3;			/* AD1852 */
extern	float			Left_Channel_SPDIF_rx;
extern	float			Right_Channel_SPDIF_rx;

// input channels
extern 	float			Left_Channel_In0;			/* Input values from the 2 AD1836 internal stereo ADCs */
extern 	float			Left_Channel_In1;			/* 1/8th inch stereo jack connected to internal stereo ADC1 */
extern 	float 			Right_Channel_In0;
extern 	float 			Right_Channel_In1;
extern 	float			Left_Channel_SPDIF_rx;		/* Input values from the DAR CS8414 */
extern 	float			Right_Channel_SPDIF_rx;
//output channels
extern 	float			Left_Channel_Out0;			/* Output values for the 3 AD1836 internal stereo DACs */
extern 	float 			Left_Channel_Out1;         /* Left and Right Channel 0 DACs go to headphone jack */
extern 	float 			Left_Channel_Out2;
extern 	float			Right_Channel_Out0;
extern 	float			Right_Channel_Out1;
extern 	float			Right_Channel_Out2;
extern 	float			Left_Channel_AD1852;		/* Output values for AD1852 stereo DAC */
extern 	float			Right_Channel_AD1852;

#else
/* Insert Assembly Definitions here.... */


#endif
/* Insert global definitions here */



// AD1836 codec SPI control/status register definitions
#define		READ_REG		0x0800
#define		WRITE_REG		0x0000
#define		DAC_CONTROL1	0x0000
#define		DAC_CONTROL2	0x1000
#define		DAC_VOLUME0		0x2000
#define		DAC_VOLUME1		0x3000
#define		DAC_VOLUME2		0x4000
#define		DAC_VOLUME3		0x5000
#define		DAC_VOLUME4		0x6000
#define		DAC_VOLUME5		0x7000
#define		ADC0_PEAK_LEVEL	0x8000
#define		ADC1_PEAK_LEVEL	0x9000
#define		ADC2_PEAK_LEVEL	0xA000
#define		ADC3_PEAK_LEVEL	0xB000
#define		ADC_CONTROL1	0xC000
#define		ADC_CONTROL2	0xD000
#define		ADC_CONTROL3	0xE000
#define		RESERVED_REG	0xF000

#define		NCH_8		0x000000E0	/* Number of MCM channels - 1 	*/

#define 	Initialize_TDM			0xD380			/* 1101 0001 1000 0000*/

/* AD1836 TDM Timeslot Definitions */
#define		Internal_ADC_L0			0
#define		Internal_ADC_L1			1
#define		AUX_ADC_L0				2
#define		AUX_ADC_L1				3
#define		Internal_ADC_R0			4
#define		Internal_ADC_R1			5
#define		AUX_ADC_R0				6
#define		AUX_ADC_R1				7

#define		Internal_DAC_L0			0
#define		Internal_DAC_L1			1
#define		Internal_DAC_L2			2
#define		AUX_DAC_L0				3
#define		Internal_DAC_R0			4
#define		Internal_DAC_R1			5
#define		Internal_DAC_R2			6
#define		AUX_DAC_R0				7

/* Leave a safety margin of 5x for the 1836 */
#define 	AD1836_RESET_CYCLES		300			
#define 	AD1836_WARMUP_CYCLES	60000	

/* AD1852 Defines */
#define		VOLUME_LEFT		0x0
#define		VOLUME_RIGHT	0x2
#define		CONTROL_REG		0x1

// AD1852 control word parameters
#define		DEASSERT_RESET	0x0000
#define		INTERP2xMODE	0x0800
#define		INTERP4xMODE	0x0400
#define		WL_24_BIT_DATA	0x0000
#define		WL_20_BIT_DATA	0x0100
#define		WL_16_BIT_DATA	0x0200
#define		RESET_AD1852	0x0080
#define		SOFT_MUTE		0x0040
#define		RIGHT_JUSTIFIED	0x0000
#define		I2S_JUSTIFIED	0x0010
#define		LEFT_JUSTIFIED	0x0020
#define		DSP_SERIAL		0x0030
#define		NO_DEMPH_FILTER	0x0000
#define		FILTER_44_1_kHz	0x0004
#define		FILTER_32_kHz	0x0008
#define		FILTER_48_kHz	0x000C	

/* SDRAM Defines */
#define sdram_size 0xfffff

