#include <asm_sprt.h>

#include <def21161.h>
#include "adds_21161_ezkit.h"

.segment /dm seg_dmda;

/* AD1836 stereo-channel data holders - used for DSP processing of audio data received from codec */
// input channels
.var 			_Left_Channel_In0;			/* Input values from the 2 AD1836 internal stereo ADCs */
.var			_Left_Channel_In1;			/* 1/8th inch stereo jack connected to internal stereo ADC1 */
.var 			_Right_Channel_In0;
.var 			_Right_Channel_In1;
.var			_Left_Channel_SPDIF_rx;		/* Input values from the DAR CS8414 */
.var			_Right_Channel_SPDIF_rx;
//output channels
.var			_Left_Channel_Out0;			/* Output values for the 3 AD1836 internal stereo DACs */
.var 			_Left_Channel_Out1;         /* Left and Right Channel 0 DACs go to headphone jack */
.var 			_Left_Channel_Out2;
.var			_Right_Channel_Out0;
.var			_Right_Channel_Out1;
.var			_Right_Channel_Out2;
.var			_Left_Channel_AD1852;		/* Output values for AD1852 stereo DAC */
.var			_Right_Channel_AD1852;

.var			_Left_Channel;				/* Can use these variables as intermediate results to next filtering stage */
.var            _Right_Channel;

.global			_Left_Channel_In0;
.global			_Left_Channel_In1;
.global			_Right_Channel_In0;
.global			_Right_Channel_In1;
.global 		_Left_Channel_Out0;		
.global			_Left_Channel_Out1;
.global			_Left_Channel_Out2;
.global 		_Right_Channel_Out0;
.global 		_Right_Channel_Out1;
.global 		_Right_Channel_Out2;
.global			_Left_Channel_AD1852;
.global 		_Right_Channel_AD1852;
.global			_Left_Channel_SPDIF_rx;
.global			_Right_Channel_SPDIF_rx;

.extern			_rx0a_buf;
.extern			_tx2a_buf;
.endseg;


.segment /pm seg_pmco;

_Receive_Samples:
.global _Receive_Samples;
//void	Receive_Samples();
	/* get AD1836 left channel input samples, save to data holders for processing */
	r1 = -31;
	r0 = dm(_rx0a_buf + Internal_ADC_L0);	f0 = float r0 by r1;	dm(_Left_Channel_In0) = r0;			
	r0 = dm(_rx0a_buf + Internal_ADC_L1);	f0 = float r0 by r1;	dm(_Left_Channel_In1) = r0;			
	r0 = dm(_rx0a_buf + AUX_ADC_L0);		f0 = float r0 by r1;	dm(_Left_Channel_SPDIF_rx) = r0;

	/* get AD1836 right channel input samples, save to data holders for processing */
	r0 = dm(_rx0a_buf + Internal_ADC_R0);	f0 = float r0 by r1;	dm(_Right_Channel_In0) = r0;			
 	r0 = dm(_rx0a_buf + Internal_ADC_R1);	f0 = float r0 by r1;	dm(_Right_Channel_In1) = r0;		
	r0 = dm(_rx0a_buf + AUX_ADC_R0);		f0 = float r0 by r1;	dm(_Right_Channel_SPDIF_rx) = r0;
	
	leaf_exit;
_Receive_Samples.end:


_Transmit_Samples:
.global _Transmit_Samples;

	r1 = 31;

	/* output processed left ch audio samples to AD1836 */
	r0 = dm(_Left_Channel_Out0);	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_L0) = r0;
	r0 = dm(_Left_Channel_Out1);	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_L1) = r0;
	r0 = dm(_Left_Channel_Out2);	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_L2) = r0;
	r0 = dm(_Left_Channel_AD1852);	r0 = trunc f0 by r1;	dm(_tx2a_buf + AUX_DAC_L0) = r0;

	/* output processed right ch audio samples to AD1836 */
	r0 = dm(_Right_Channel_Out0); 	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_R0) = r0;
	r0 = dm(_Right_Channel_Out1);	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_R1) = r0;
	r0 = dm(_Right_Channel_Out2);	r0 = trunc f0 by r1;	dm(_tx2a_buf + Internal_DAC_R2) = r0;
	r0 = dm(_Right_Channel_AD1852);	r0 = trunc f0 by r1;	dm(_tx2a_buf + AUX_DAC_R0) = r0;

	leaf_exit;
_Transmit_Samples.end:

.endseg;
