#include "ADDS_21161_EzKit.h"
#include <def21161.h>

#include <signal.h>
#define beta 0.01
#define N 5

float delay[N];
float w[N];
int Index  = 0;

void	Process_Samples( int sig_int)
{
	short i;
	float yn=0, E=0, dplusn=0, noise=0;
	
	
	Receive_Samples();

	/* Perform AD1836/AD1852/SPDIF Audio Processing Here */

	dplusn 	= Left_Channel_In0;
	noise 	= Right_Channel_In0;
	delay[0] = noise;
	yn = 0;
	E = 0;
	for (i=0; i<N; i++){
		yn+=(w[i]*delay[i]);
	}
	E = dplusn-yn;
	for (i=N-1; i>=0; i--){
		w[i]=w[i] + beta*E*delay[i];
		delay[i] = delay[i-1];
	}
	
	Left_Channel_Out0 = E;
	//Right_Channel_Out0 = yn;
	
	Left_Channel_Out1 = Left_Channel_In0;
	Right_Channel_Out1 = Right_Channel_In0;

	Transmit_Samples();
}


void	main()
{
	short T=0;
	/* Setup Interrupt edges and flag I/O directions */
	Setup_ADSP21161N();

	/* Setup SDRAM Controller */
	Setup_SDRAM();

	Setup_AD1836();
	Init_AD1852_DACs();

	Program_SPORT02_TDM_Registers();
	Program_SPORT02_DMA_Channels();

	interruptf(	SIG_SP0I,	Process_Samples);

	*(int *) SP02MCTL |= MCE;

	for (T=0; T < N; T++){
		w[T] = 1;
		delay[T] = 0;
	}
	
	for (;;)
		asm("idle;");


}
