/* MAIN.ASM    is a testing shell  for the Adaptive Filtering Algorithms, 
                 such as the various Least Mean Squares (LMS) algorithms and
		 the Recursive Least Squares (RLS) algorithm. This file has to
		 be edited to conform with the algorithm employed.

	***********************************************************************
	*   This program generates a moving average sequence of real samples, *
	* and employs the adaptive filter for System Identification based on  *
	* a transversal FIR filter structure. The generating plant is         *
	* described by the following difference equation:		      *
	*               y(n)= x(n-1)-0.5x(n-2)-x(n-3)                         *
	* where the plant impulse response is 0, 1, -0.5, -1, 0, 0, ... .     *
	*   The filter is allowed five weight coefficients. The input data    *
	* sequence is a pseudonoise process with a period of 20.              *
	*   This program is also used to test adaptive filters based on both  *
	* symmetric transversal FIR and lattice FIR structures. The output    *
	* filter error signal is stored in a data buffer named [flt_err]      * 
	* for comparison.                                                     *
	*   Place * s in this file with the corresponding code                * 
	*********************************************************************** 

      Written by : Wassim G. Najm, Analog Devices, DSP division, April 2 1991

OPIS ALGORYTMOW ADAPTACYJNYCH (LMS, RLS, ...)     
INPUT:      
	f0= u(n)= input sample (wejscie filtru adaptacyjnego (FIR))
    f1 lub f9 = d(n)= desired output  	(REG_DESIRED)  
		//f1 for lms, nlms, llms, selms, sdlms, sslms,sylms
		//f9 for latlms and RLS
OUPUT:
	f13= y(n)= filter output			(REG_OUTPUT)
	f1 lub f6 = e(n)= filter "a priori" error signal	(REG_ERROR)		
		//f6 for lms, llms, nlms, sdlms, sylms, latlms
		//f1 for selms, sslms, rls     
		
OPIS STRUMIENIA WEJSCIOWEGO I WYJSCIOWEGO
W projekcie zostaly zdefiniowane strumienie (wiecej informacji w instrukcji) zmapowane pod dane adresy:
- strumienie wejsciowe:	
	0xFFD00000	-> data_primary.dat
	0xFFD00001	-> data_reference.dat
- strumienie wyjsciowe:	
	0xFFD00002	-> data_output.dat
	0xFFD00003	-> data_error.dat	
      
*/

#include "def21161.h"

#define LMS
//#define RLS
#ifdef RLS
	#define INIT 		rls_init
	#define ALG 		rls_alg
	#define REG_ERROR 	f1
	#define REG_DESIRED	f9
	#define REG_OUTPUT 	f13	
#endif
#ifdef LMS
	#define INIT		lms_init
	#define ALG			lms_alg
	#define REG_ERROR	f6
	#define REG_DESIRED	f1
	#define REG_OUTPUT	f13
#endif	


#define	SAMPLES	39000		//ilosc probek do przetworzenia	
#define bufor_length 2000	//dlugosc wektorow sluzacych do podgladu wejsc/wyjsc
	
.EXTERN INIT, ALG; 

.SEGMENT/DM	seg_dmda;
.VAR	buffer1[bufor_length];
.VAR 	buffer2[bufor_length];
.ENDSEG;

.SEGMENT/PM	seg_pmda;
.ENDSEG;

.section/pm   seg_rth;
Reserved_1:     rti; nop; nop; nop;
Chip_Reset:     idle; jump begin; nop; nop;

.SEGMENT/PM	seg_pmco;
begin:		
		bit set MODE1 CBUFEN;
		b6=buffer1;	l6=@buffer1; m6=1;		
		m15=1;			
		m7=1;
		
		b5 = buffer2; l5=@buffer2; m5=1;
		
		call INIT; 

		//GLOWNA PETLA PROGRAMU//
		lcntr=SAMPLES, do adapt_filter until lce;
		    
			//przygotowanie danych wejsciowych            
			f0 = dm(0xFFD00001);	//data_primary			
			REG_DESIRED = dm(0xFFD00000);	
									//reg_desired->	f1 - dla lms,nlms...
									//				f9 - dla latlms i rls
		  	dm(i5,m5)=REG_DESIRED;		//zapisanie sygnalu desired w buffer2[]
			
        	//wywolanie algorytmu filtracji adaptacyjnej
			call ALG; 
		  	
        	//zapisanie danych        	
          	dm(i6,m6)=REG_ERROR; 	//zapisanie wyjscia bledu do wektora buffer1 (tylko w celu podgladu zawartosci)
			    					//reg_error->	f6 for lms 
			    					//R	 			f1 for rls 			
			
			dm(0xFFD00002)=REG_OUTPUT;		//zapisanie wyjscia yn filtru do pliku data_output
			dm(0xFFD00003)=REG_ERROR;	//zapisanie wyjscia bledu E do pliku data_error						
					    
		  	nop;
adapt_filter:     nop;		
		idle;		
		
begin.end:		
.ENDSEG;
