/*----------------------------------------------------------------------------
FILE:           b2b.c
DESCRIPTION:    Reads bytes created by code2bytes.c, generates Motorola
                Exorciser-format S-records for burning EPROMs.
                Part of pub21k.c program.
AUTHOR:         Jim Donahue, Analog Devices DSP Division (617) 461-3672
DATE:           6/13/91
----------------------------------------------------------------------------*/
#include "pub21k.h"
#define BYTES_PER_RECORD    8

/*----------------------------------------------------------------------------
SUBROUTINE:     makeSrecord
DESCRIPTION:    make an S-record format data record

        The S-record format is "TTLLAAAADDDDDDDDDDDDDDDDCC", where
        TT = 2-character type of S record = S1
        LL = 4-char length, in bytes, of address,data, and checksum fields
        AAAA = 4-character address
        DDDDDDDDDDDDDDDD = 8 bytes of EPROM data
        CC = checksum = 1's comp of least sig. byte of sum of all bytes 
                        EXCEPT the type byte.
        All fields are hex values.
----------------------------------------------------------------------------*/
void makeSrecord(FILE *outfilep, long num, BYTE_ARRAY *bytes) 
{
    long    i;
    ULONG   chksum;

    chksum = BYTES_PER_RECORD + 3;
    chksum += (num & 0xFF);
    chksum += ((num & 0xFF00) >> 8);
    fprintf (outfilep, "S1%02.2X%04.4X", BYTES_PER_RECORD+3, num);
    for(i=num; i<num+BYTES_PER_RECORD;i++){
        fprintf(outfilep, "%02.2X", bytes[i]);
        chksum += bytes[i];
    }
    fprintf(outfilep, "%02.2X\n", (~chksum) & 0xFF);
}

/*----------------------------------------------------------------------------
SUBROUTINE:     makeStail
DESCRIPTION:    make a S-record format termination record

    This is a canned terminator record from Motorola's description of
    S-records.
----------------------------------------------------------------------------*/
void makeStail(FILE *outfilep) 
{
    fprintf(outfilep, "S9030000FC\n");
}

/*----------------------------------------------------------------------------
SUBROUTINE:     bytes2burn
DESCRIPTION:    turn PROM bytes into .S0 format for PROM burner
----------------------------------------------------------------------------*/
void bytes2burn(BYTE_ARRAY *bytes, FILE *outfilep) 
{
    long i;

    for(i=0; i<EPROMSZ; i+=BYTES_PER_RECORD) {
        makeSrecord(outfilep, i, bytes);
    }    

    makeStail(outfilep);
}


