/*----------------------------------------------------------------------------
FILE:           pub21k.c
DESCRIPTION:    Reads spl21k stacked-format output files, writes Motorola
                Exorciser-format S-records for burning EPROMs for the 
                EPROM-based 21020 JTAG Downloader Board.
REQUIRED:       s2c.c, c2b.c, b2b.c, stox.c
AUTHOR:         Jim Donahue, Analog Devices DSP Division (617) 461-3672
DATE:           6/13/91
----------------------------------------------------------------------------*/
#include "pub21k.h"

/*----------------------------------------------------------------------------
Main program
----------------------------------------------------------------------------*/
main (int argc, char *argv[]) 
{
    OBJCODE     code[MAXLINES];
    BYTE_ARRAY  *bytes;
    char        infile[ARGCHARS];
    char        outfile[ARGCHARS];
    FILE        *ip, *op;
    long        i;
    ULONG       bankaddr=0xFFFFFF;

    /* Process arguments:                                                   */
    /*      argv[1] = root name of files                                    */
    /*      argv[2] = start address of Program Memory Bank 1, in hex        */
    switch (argc) {
        case 3:
            strncpy (infile, argv[1], ARGCHARS-1);
            strcat (infile, ".stk");
            bankaddr = stox(argv[2], ARGCHARS);
            strncpy (outfile, argv[1], ARGCHARS-1);
            strcat (outfile, ".s0");
            break;
        default:
            fprintf (stderr, 
                "Usage:       pub21k ROOT_NAME BANK_ADDDR\n");
            fprintf (stderr, 
                "Description: reads ROOT_NAME.stk, generates ROOT_NAME.s0\n");
            fprintf (stderr, 
"Notes:       generate ROOT_NAME.stk with");
            fprintf (stderr, 
"\n           \"spl21k -a ARCH_NAME -f B |-ram| -pm ROOT_NAME\"\n");
            fprintf (stderr, 
                "             BANK_ADDR = start address of PM Bank 1, in hex\n");
            exit(1);
    }

#ifdef DEBUG
    printf ("main: using input file  %s\n", infile);
    printf ("main: using bank addr   %08.8X\n", bankaddr);
    printf ("main: using output file %s\n", outfile);
#endif

    /* Allocate memory for bytes array */
    if ((bytes = (BYTE_ARRAY *)CALLOC(EPROMSZ, sizeof(BYTE_ARRAY))) == NULL){
        fprintf (stderr, "ERROR: can't allocate memory for bytes array\n");
        exit(1);
    }

    /* Initialization */
    for (i=0; i<EPROMSZ; i++) *(bytes+i) = (char) NULL;
    for (i=0; i<MAXLINES; i++) code[i].bank = ENDFLG;
    if ((ip = fopen(infile,"r")) == NULL) {
        fprintf (stderr, "ERROR: Can't open input file %s\n", infile);
        exit(1);
    }
    if ((op = fopen(outfile,"w"))==NULL) {
        fprintf (stderr, "ERROR: Can't open output file %s\n", outfile);
        exit(1);
    }

    /* read .stk file (stacked format), put results into code array */
    spl2code(ip, bankaddr, code);

    /* translate code into bytes for PROM */
    code2bytes(code, bytes);

    /* translate PROM bytes into Moto's S-record format */
    bytes2burn(bytes, op);

}
