/*----------------------------------------------------------------------------
FILE:           stox.c
DESCRIPTION:    converts hexadecimal string to integer
AUTHOR:         Jim Donahue, Analog Devices DSP Division (617) 461-3672
DATE:           6/17/91
----------------------------------------------------------------------------*/
#ifndef ULONG
typedef unsigned long ULONG;
#endif

ULONG stox (char *str, int chars)
{
    ULONG val = 0L;

    for ( ; chars>0 && *str!='\0'; chars--, str++) {
        val = val << 4;
        if (*str>='0' && *str<='9') 
            val += (ULONG) (*str-'0');
        else if (*str>='a' && *str<='f') 
            val += (ULONG) (*str-'a'+10);
        else if (*str>='A' && *str<='F') 
            val += (ULONG) (*str-'A'+10);
    }
    return(val);
}
